#include "UserDataRecovery.h"
#include "utils/data-collection/EventLogMgr.h"

UserDataRecovery::UserDataRecovery()
{

}

UserDataRecovery::~UserDataRecovery()
{

}

void UserDataRecovery::reportEventLog(const ResultInfo &resultInfo, OperateType opType, RecoveryType recoveryType)
{
    QJsonObject dataObj;
    if (opType == OperateType::UserDataBackup) {
        BackupEventData backupData;
        backupData.tid = EventTid::TID_DATA_BACKUP;
        backupData.resInfo = resultInfo;
        backupData.operateType = "UserDataBackup";
        backupData.backupType = getRecoveryType(recoveryType);
        dataObj = backupData.marshal();
    } else if (opType == OperateType::UserDataRestore) {
        RestoreEventData restoreData;
        restoreData.tid = EventTid::TID_DATA_RESTORE;
        restoreData.resInfo = resultInfo;
        restoreData.operateType = "UserDataRestore";
        restoreData.restoreType = getRecoveryType(recoveryType);
        dataObj = restoreData.marshal();
    } else {
        return;
    }

    EventLogMgr *eventLogMgr = EventLogMgr::getInstance();
    if (eventLogMgr->isInited()) {
        eventLogMgr->writeEventLog(dataObj);
    }
}
